/*
 * Decompiled with CFR 0.152.
 */
package filenet.ws.utils;

import filenet.vw.api.VWException;
import filenet.vw.base.logging.Level;
import filenet.vw.base.logging.Logger;
import filenet.ws.utils.jsse.WSJSSE;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.StringTokenizer;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class WSValidateServerCertificate {
    public static final String TRUSTSTORE_PROPERTY = "javax.net.ssl.trustStore";
    public static final String TRUSTSTORE_PASSWORD_PROPERTY = "javax.net.ssl.trustStorePassword";
    protected static Logger logger = Logger.getLogger("filenet.ws.api");
    protected static String m_className = "WSValidateServerCertificate";
    static boolean s_bProcessTrustStoreSaved = false;
    static String s_defaultTrustStoreProperty = System.getProperty("javax.net.ssl.trustStore");
    static String s_defaultTrustStorePath = WSValidateServerCertificate.getDefaultTrustStorePath();
    static String s_processTrustStorePath = WSValidateServerCertificate.getProcessTrustStorePath();
    static char[] s_processTrustStorePassword = "changeit".toCharArray();
    private boolean m_bCertificateAdded = false;
    private KeyStore m_processTrustStore = null;
    private boolean m_bAutoTrusted = true;
    private boolean m_bValidating = false;
    private Exception[] m_exceptions = null;
    private boolean[] m_validationResults = null;
    private int m_serverIndex = -1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public synchronized String getContents(String httpsURL) {
        Exception e222222222222;
        String string;
        String res;
        PrintWriter outS;
        PrintWriter outF;
        BufferedReader inS;
        Socket socket;
        String m_method;
        block82: {
            String inputLine;
            File f;
            block77: {
                Exception e222222222222;
                String string2;
                block78: {
                    block72: {
                        Exception e222222222222;
                        String string3;
                        block73: {
                            m_method = "getContents:" + httpsURL;
                            socket = null;
                            inS = null;
                            outF = null;
                            outS = null;
                            res = null;
                            logger.entering(m_className, m_method);
                            this.m_bValidating = true;
                            this.m_exceptions = null;
                            this.m_validationResults = new boolean[1];
                            this.m_exceptions = new Exception[1];
                            URL url = null;
                            InternalEasySSLSocketFactory socketFactory = new InternalEasySSLSocketFactory();
                            this.m_serverIndex = 0;
                            try {
                                url = new URL(httpsURL);
                            }
                            catch (MalformedURLException ex) {
                                Exception e222222222222;
                                this.m_validationResults[this.m_serverIndex] = false;
                                this.m_exceptions[this.m_serverIndex] = ex;
                                String string4 = res;
                                Object var17_15 = null;
                                if (inS != null) {
                                    try {
                                        inS.close();
                                    }
                                    catch (Exception e222222222222) {
                                        // empty catch block
                                    }
                                }
                                if (outS != null) {
                                    try {
                                        outS.close();
                                    }
                                    catch (Exception e222222222222) {
                                        // empty catch block
                                    }
                                }
                                if (outF != null) {
                                    try {
                                        outF.close();
                                    }
                                    catch (Exception e222222222222) {
                                        // empty catch block
                                    }
                                }
                                if (socket != null) {
                                    try {
                                        socket.close();
                                        socket = null;
                                    }
                                    catch (Exception e222222222222) {
                                        // empty catch block
                                    }
                                }
                                WSValidateServerCertificate.useDefaultTrustStore();
                                if (logger.isFinest()) {
                                    logger.finest(m_className, m_method, "EXIT, res=" + res);
                                }
                                return string4;
                            }
                            String host = url.getHost();
                            int port = url.getPort();
                            if (port == -1) {
                                port = 443;
                            }
                            if (logger.isFinest()) {
                                logger.finest(m_className, m_method, "creating socket " + host + ":" + Integer.toString(port));
                            }
                            WSValidateServerCertificate.useProcessTrustStore();
                            socket = (SSLSocket)socketFactory.createSocket(host, port);
                            ((SSLSocket)socket).startHandshake();
                            outS = new PrintWriter(new BufferedWriter(new OutputStreamWriter(socket.getOutputStream())));
                            outS.println("GET " + httpsURL + " HTTP/1.0");
                            outS.println();
                            outS.flush();
                            if (!outS.checkError()) break block72;
                            VWException ex = new VWException("filenet.ws.utils.failedToWriteToHttps", "Failed to write to {0}", httpsURL);
                            logger.throwing(m_className, m_method, ex);
                            this.m_exceptions[this.m_serverIndex] = ex;
                            string3 = null;
                            Object var17_16 = null;
                            if (inS == null) break block73;
                            try {
                                inS.close();
                            }
                            catch (Exception e222222222222) {
                                // empty catch block
                            }
                        }
                        if (outS != null) {
                            try {
                                outS.close();
                            }
                            catch (Exception e222222222222) {
                                // empty catch block
                            }
                        }
                        if (outF != null) {
                            try {
                                outF.close();
                            }
                            catch (Exception e222222222222) {
                                // empty catch block
                            }
                        }
                        if (socket != null) {
                            try {
                                socket.close();
                                socket = null;
                            }
                            catch (Exception e222222222222) {
                                // empty catch block
                            }
                        }
                        WSValidateServerCertificate.useDefaultTrustStore();
                        if (logger.isFinest()) {
                            logger.finest(m_className, m_method, "EXIT, res=" + res);
                        }
                        return string3;
                    }
                    inS = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                    f = File.createTempFile("fnws", ".wsdl");
                    inputLine = inS.readLine();
                    if (inputLine.indexOf("200 OK") != -1) break block77;
                    VWException ex = new VWException("filenet.ws.utils.failedToGetHttpsURL", "Failed to GET {0}, status={1}", httpsURL, inputLine);
                    logger.throwing(m_className, m_method, ex);
                    this.m_exceptions[this.m_serverIndex] = ex;
                    string2 = null;
                    Object var17_17 = null;
                    if (inS == null) break block78;
                    try {
                        inS.close();
                    }
                    catch (Exception e222222222222) {
                        // empty catch block
                    }
                }
                if (outS != null) {
                    try {
                        outS.close();
                    }
                    catch (Exception e222222222222) {
                        // empty catch block
                    }
                }
                if (outF != null) {
                    try {
                        outF.close();
                    }
                    catch (Exception e222222222222) {
                        // empty catch block
                    }
                }
                if (socket != null) {
                    try {
                        socket.close();
                        socket = null;
                    }
                    catch (Exception e222222222222) {
                        // empty catch block
                    }
                }
                WSValidateServerCertificate.useDefaultTrustStore();
                if (logger.isFinest()) {
                    logger.finest(m_className, m_method, "EXIT, res=" + res);
                }
                return string2;
            }
            while ((inputLine = inS.readLine()) != null) {
                if (logger.isFinest()) {
                    logger.finest(m_className, m_method, "[HTTP HEADER]" + inputLine);
                }
                if (inputLine.trim().length() != 0) continue;
            }
            StringBuffer buf = new StringBuffer();
            outF = new PrintWriter(new BufferedWriter(new FileWriter(f)));
            while ((inputLine = inS.readLine()) != null) {
                outF.println(inputLine);
                buf.append(inputLine).append("\n");
            }
            if (logger.isFinest()) {
                logger.finest(m_className, m_method, buf.toString());
            }
            inS.close();
            inS = null;
            outS.close();
            outS = null;
            outF.close();
            outF = null;
            socket.close();
            socket = null;
            this.saveProcessTrustStore();
            this.m_bValidating = false;
            this.m_validationResults[this.m_serverIndex] = true;
            this.m_exceptions[this.m_serverIndex] = null;
            string = res = f.getCanonicalPath();
            Object var17_18 = null;
            if (inS == null) break block82;
            try {
                inS.close();
            }
            catch (Exception e222222222222) {
                // empty catch block
            }
        }
        if (outS != null) {
            try {
                outS.close();
            }
            catch (Exception e222222222222) {
                // empty catch block
            }
        }
        if (outF != null) {
            try {
                outF.close();
            }
            catch (Exception e222222222222) {
                // empty catch block
            }
        }
        if (socket != null) {
            try {
                socket.close();
                socket = null;
            }
            catch (Exception e222222222222) {
                // empty catch block
            }
        }
        WSValidateServerCertificate.useDefaultTrustStore();
        if (logger.isFinest()) {
            logger.finest(m_className, m_method, "EXIT, res=" + res);
        }
        return string;
        catch (Exception ex) {
            Exception e222222222222;
            String string5;
            block86: {
                try {
                    logger.throwing(m_className, m_method, ex);
                    this.m_validationResults[this.m_serverIndex] = false;
                    this.m_exceptions[this.m_serverIndex] = ex;
                    string5 = res;
                    Object var17_19 = null;
                    if (inS == null) break block86;
                }
                catch (Throwable throwable) {
                    block90: {
                        Exception e222222222222;
                        Object var17_20 = null;
                        if (inS != null) {
                            try {
                                inS.close();
                            }
                            catch (Exception e222222222222) {
                                // empty catch block
                            }
                        }
                        if (outS != null) {
                            try {
                                outS.close();
                            }
                            catch (Exception e222222222222) {
                                // empty catch block
                            }
                        }
                        if (outF != null) {
                            try {
                                outF.close();
                            }
                            catch (Exception e222222222222) {
                                // empty catch block
                            }
                        }
                        if (socket != null) {
                            try {
                                socket.close();
                                socket = null;
                            }
                            catch (Exception e222222222222) {
                                // empty catch block
                            }
                        }
                        WSValidateServerCertificate.useDefaultTrustStore();
                        if (!logger.isFinest()) break block90;
                        logger.finest(m_className, m_method, "EXIT, res=" + res);
                    }
                    throw throwable;
                }
                try {
                    inS.close();
                }
                catch (Exception e222222222222) {
                    // empty catch block
                }
            }
            if (outS != null) {
                try {
                    outS.close();
                }
                catch (Exception e222222222222) {
                    // empty catch block
                }
            }
            if (outF != null) {
                try {
                    outF.close();
                }
                catch (Exception e222222222222) {
                    // empty catch block
                }
            }
            if (socket != null) {
                try {
                    socket.close();
                    socket = null;
                }
                catch (Exception e222222222222) {
                    // empty catch block
                }
            }
            WSValidateServerCertificate.useDefaultTrustStore();
            if (logger.isFinest()) {
                logger.finest(m_className, m_method, "EXIT, res=" + res);
            }
            return string5;
        }
    }

    public WSValidateServerCertificate() {
        String s = System.getProperty("filenet.ws.ssl.autotrust");
        this.m_bAutoTrusted = s == null || s.equals("true");
        this.initProcessTrustStore();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized void initProcessTrustStore() {
        String m_method;
        block11: {
            m_method = "initProcessTrustStore()";
            logger.entering(m_className, m_method);
            try {
                try {
                    if (s_bProcessTrustStoreSaved) {
                        Object var9_2 = null;
                        logger.exiting(m_className, m_method);
                        return;
                    }
                    WSJSSE wsjsse = WSJSSE.getInstance();
                    KeyStore trustStore = KeyStore.getInstance(wsjsse.getKeyStoreType());
                    if (s_defaultTrustStorePath != null) {
                        char[] pword = null;
                        String password = System.getProperty(TRUSTSTORE_PASSWORD_PROPERTY);
                        if (password != null) {
                            pword = password.toCharArray();
                        }
                        trustStore.load(new FileInputStream(new File(s_defaultTrustStorePath)), pword);
                        this.saveProcessTrustStore(trustStore);
                        break block11;
                    }
                    TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                    TrustManager[] trustManagers = trustManagerFactory.getTrustManagers();
                    if (trustManagers != null && trustManagers[0] != null && trustManagers[0] instanceof X509TrustManager) {
                        X509Certificate[] certificates = ((X509TrustManager)trustManagers[0]).getAcceptedIssuers();
                        if (certificates != null && certificates.length > 0) {
                            for (int i = 0; i < certificates.length; ++i) {
                                WSValidateServerCertificate.addCertificate(trustStore, certificates[i]);
                            }
                        }
                        this.saveProcessTrustStore(trustStore);
                    }
                }
                catch (Exception ex) {
                    logger.throwing(m_className, m_method, ex);
                    Object var9_4 = null;
                    logger.exiting(m_className, m_method);
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var9_5 = null;
                logger.exiting(m_className, m_method);
                throw throwable;
            }
        }
        Object var9_3 = null;
        logger.exiting(m_className, m_method);
    }

    public static String getDefaultTrustStorePath() {
        String path = System.getProperty(TRUSTSTORE_PROPERTY);
        if (path == null) {
            path = System.getProperty("java.home") + File.separator + "lib" + File.separator + "security" + File.separator + "cacerts";
        }
        return path;
    }

    private static String getProcessTrustStorePath() {
        String path = System.getProperty("java.io.tmpdir") + File.separator + "cacerts";
        return path;
    }

    private static void traceProperties() {
        String m_method = "traceProperties";
        if (!logger.isLoggable(Level.FINEST)) {
            return;
        }
        String s = "javax.net.ssl.trustStore=" + System.getProperty(TRUSTSTORE_PROPERTY) + "\n" + TRUSTSTORE_PASSWORD_PROPERTY + "=" + System.getProperty(TRUSTSTORE_PASSWORD_PROPERTY);
        if (logger.isFinest()) {
            logger.finest(m_className, "traceProperties", s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void useDefaultTrustStore() {
        String m_method = "useDefaultTrustStore";
        try {
            try {
                logger.entering(m_className, "useDefaultTrustStore");
                WSValidateServerCertificate.useProcessTrustStore();
            }
            catch (Exception ex) {
                logger.throwing(m_className, "useDefaultTrustStore", ex);
                Object var3_2 = null;
                logger.exiting(m_className, "useDefaultTrustStore");
            }
            Object var3_1 = null;
            logger.exiting(m_className, "useDefaultTrustStore");
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            logger.exiting(m_className, "useDefaultTrustStore");
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void useProcessTrustStore() {
        String m_method = "useProcessTrustStore";
        try {
            try {
                logger.entering(m_className, "useProcessTrustStore");
                System.setProperty(TRUSTSTORE_PROPERTY, s_processTrustStorePath);
                WSValidateServerCertificate.traceProperties();
                logger.exiting(m_className, "useProcessTrustStore");
                WSValidateServerCertificate.traceProperties();
            }
            catch (Exception ex) {
                logger.throwing(m_className, "useProcessTrustStore", ex);
                Object var3_2 = null;
                logger.exiting(m_className, "useProcessTrustStore");
            }
            Object var3_1 = null;
            logger.exiting(m_className, "useProcessTrustStore");
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            logger.exiting(m_className, "useProcessTrustStore");
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized boolean saveProcessTrustStore(KeyStore trustStore) {
        String m_method = "saveProcessTrustStore";
        logger.entering(m_className, "saveProcessTrustStore");
        try {
            boolean bl;
            String string = s_processTrustStorePath;
            synchronized (string) {
                File file = new File(s_processTrustStorePath);
                try {
                    FileOutputStream outputStream = new FileOutputStream(file);
                    trustStore.store(outputStream, s_processTrustStorePassword);
                    outputStream.flush();
                    outputStream.close();
                    s_bProcessTrustStoreSaved = true;
                    if (logger.isFinest()) {
                        logger.finest(m_className, "saveProcessTrustStore", "saved to " + s_processTrustStorePath);
                    }
                    bl = true;
                }
                catch (Exception ex) {
                    logger.throwing(m_className, "saveProcessTrustStore", ex);
                    boolean bl2 = false;
                    // MONITOREXIT @DISABLED, blocks:[0, 4, 5] lbl21 : MonitorExitStatement: MONITOREXIT : var3_3
                    Object var9_10 = null;
                    logger.exiting(m_className, "saveProcessTrustStore");
                    return bl2;
                }
            }
            Object var9_9 = null;
            logger.exiting(m_className, "saveProcessTrustStore");
            return bl;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            logger.exiting(m_className, "saveProcessTrustStore");
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean saveProcessTrustStore() {
        block3: {
            String m_method = "saveProcessTrustStore";
            logger.entering(m_className, "saveProcessTrustStore");
            try {
                if (this.m_processTrustStore != null && this.m_bCertificateAdded) break block3;
                boolean bl = false;
                Object var4_4 = null;
                logger.exiting(m_className, "saveProcessTrustStore");
                return bl;
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                logger.exiting(m_className, "saveProcessTrustStore");
                throw throwable;
            }
        }
        boolean bl = this.saveProcessTrustStore(this.m_processTrustStore);
        Object var4_5 = null;
        logger.exiting(m_className, "saveProcessTrustStore");
        return bl;
    }

    public synchronized boolean[] validateServers(String[] urls) {
        String m_method = "validateServers";
        if (this.m_bValidating) {
            return null;
        }
        this.m_bValidating = true;
        this.m_exceptions = null;
        if (urls == null || urls.length == 0) {
            return null;
        }
        this.m_validationResults = new boolean[urls.length];
        this.m_exceptions = new Exception[urls.length];
        String urlString = null;
        URL url = null;
        InternalEasySSLSocketFactory socketFactory = new InternalEasySSLSocketFactory();
        this.m_serverIndex = 0;
        while (this.m_serverIndex < urls.length) {
            block17: {
                urlString = urls[this.m_serverIndex];
                if (urlString != null) {
                    boolean bIsSec;
                    block16: {
                        bIsSec = false;
                        if (logger.isFinest()) {
                            logger.finest(m_className, "validateServers", "Checking " + urlString);
                        }
                        this.m_validationResults[this.m_serverIndex] = true;
                        this.m_exceptions[this.m_serverIndex] = null;
                        try {
                            url = new URL(urlString);
                            if (url.getProtocol() == null || url.getProtocol().compareTo("https") != 0) break block16;
                            bIsSec = true;
                        }
                        catch (MalformedURLException ex) {
                            this.m_validationResults[this.m_serverIndex] = false;
                            this.m_exceptions[this.m_serverIndex] = ex;
                            break block17;
                        }
                    }
                    if (!bIsSec) {
                        try {
                            URLConnection conn = url.openConnection();
                            conn.connect();
                        }
                        catch (Exception ex) {
                            this.m_validationResults[this.m_serverIndex] = false;
                            this.m_exceptions[this.m_serverIndex] = ex;
                        }
                    } else {
                        String host = url.getHost();
                        int port = url.getPort();
                        if (port == -1) {
                            port = 443;
                        }
                        try {
                            if (logger.isFinest()) {
                                logger.finest(m_className, "validateServers", "creating socket");
                            }
                            SSLSocket socket = (SSLSocket)socketFactory.createSocket(host, port);
                            socket.startHandshake();
                            socket.close();
                            if (logger.isFinest()) {
                                logger.finest(m_className, "validateServers", "closed socket");
                            }
                            this.m_validationResults[this.m_serverIndex] = true;
                            this.m_exceptions[this.m_serverIndex] = null;
                        }
                        catch (Exception ex) {
                            this.m_validationResults[this.m_serverIndex] = false;
                            this.m_exceptions[this.m_serverIndex] = ex;
                        }
                    }
                }
            }
            ++this.m_serverIndex;
        }
        this.saveProcessTrustStore();
        this.m_bValidating = false;
        return this.m_validationResults;
    }

    public Exception[] getValidateServerExceptions() {
        if (!this.m_bValidating) {
            return this.m_exceptions;
        }
        return null;
    }

    private static void addCertificate(KeyStore trustStore, X509Certificate certificate) throws Exception {
        String m_method = "addCertificate";
        try {
            block5: {
                try {
                    logger.entering(m_className, m_method);
                    String alias = WSValidateServerCertificate.getCertificateAlias(certificate);
                    if (alias == null) break block5;
                    int i = 0;
                    String name = alias;
                    while (trustStore.getCertificate(name) != null) {
                        name = alias + i;
                        ++i;
                    }
                    alias = name;
                    trustStore.setCertificateEntry(alias, certificate);
                    if (!logger.isFinest()) break block5;
                    logger.finest(m_className, m_method, "set " + alias + " cert to trustStore");
                }
                catch (Exception ex) {
                    logger.throwing(m_className, m_method, ex);
                    throw ex;
                }
            }
            Object var7_7 = null;
            logger.exiting(m_className, m_method);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            logger.exiting(m_className, m_method);
            throw throwable;
        }
    }

    private static String getCertificateAlias(X509Certificate certificate) {
        if (certificate == null) {
            return null;
        }
        if (certificate.getIssuerDN() == null) {
            return null;
        }
        String cnName = certificate.getSubjectDN().getName() + certificate.getIssuerDN().getName();
        String m_method = "getCertificateAlias:" + cnName;
        logger.entering(m_className, m_method);
        String alias = null;
        if (cnName != null) {
            StringTokenizer tokenizer = new StringTokenizer(cnName, "=,");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if (token == null || token.compareToIgnoreCase("CN") != 0 && token.compareToIgnoreCase("OU") != 0 || !tokenizer.hasMoreTokens()) continue;
                alias = tokenizer.nextToken();
                if (alias == null) break;
                alias = alias.replace(' ', '-');
                break;
            }
        }
        logger.exiting(m_className, m_method);
        if (alias == null) {
            alias = new String("certAlias");
        }
        return alias;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean handleUntrustedCertificates(KeyStore trustStore, X509Certificate[] certificates) {
        boolean bl;
        block14: {
            boolean alias2;
            block13: {
                String m_method = "handleUntrustedCertificates";
                logger.entering(m_className, "handleUntrustedCertificates");
                try {
                    if (certificates != null) {
                        X509Certificate certificate = null;
                        certificate = certificates[0];
                        if (certificate == null) {
                            boolean bl2 = false;
                            Object var9_10 = null;
                            logger.exiting(m_className, "handleUntrustedCertificates");
                            return bl2;
                        }
                        try {
                            certificate.checkValidity();
                            if (this.m_bValidating) {
                                String alias2;
                                if (this.m_processTrustStore == null) {
                                    this.m_processTrustStore = trustStore;
                                    this.m_bCertificateAdded = false;
                                }
                                if ((alias2 = WSValidateServerCertificate.getCertificateAlias(certificate)) != null) {
                                    int i = 0;
                                    String name = alias2;
                                    while (this.m_processTrustStore.getCertificate(name) != null) {
                                        name = alias2 + i;
                                        ++i;
                                    }
                                    alias2 = name;
                                    this.m_processTrustStore.setCertificateEntry(alias2, certificate);
                                    this.m_bCertificateAdded = true;
                                    this.m_validationResults[this.m_serverIndex] = true;
                                    this.m_exceptions[this.m_serverIndex] = null;
                                    if (logger.isFinest()) {
                                        logger.finest(m_className, "handleUntrustedCertificates", "set " + alias2 + " cert to trustStore");
                                    }
                                }
                            }
                            alias2 = true;
                            break block13;
                        }
                        catch (Exception ex) {
                            logger.throwing(m_className, "handleUntrustedCertificates", ex);
                            if (this.m_bValidating) {
                                this.m_validationResults[this.m_serverIndex] = false;
                                this.m_exceptions[this.m_serverIndex] = ex;
                            }
                            boolean bl3 = false;
                            Object var9_12 = null;
                            logger.exiting(m_className, "handleUntrustedCertificates");
                            return bl3;
                        }
                    }
                    bl = false;
                    break block14;
                }
                catch (Throwable throwable) {
                    Object var9_14 = null;
                    logger.exiting(m_className, "handleUntrustedCertificates");
                    throw throwable;
                }
            }
            Object var9_11 = null;
            logger.exiting(m_className, "handleUntrustedCertificates");
            return alias2;
        }
        Object var9_13 = null;
        logger.exiting(m_className, "handleUntrustedCertificates");
        return bl;
    }

    public static String _get_FILE_DATE() {
        return "$Date:   15 Oct 2008 18:20:12  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   qdang  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.15  $";
    }

    static {
        try {
            WSJSSE.getAutoTrustSSL();
            WSValidateServerCertificate.traceProperties();
        }
        catch (Exception ex) {
            logger.throwing(m_className, "loading WSSSE class", ex);
        }
    }

    public class InternalEasyX509TrustManager
    implements X509TrustManager {
        private X509TrustManager standardTrustManager = null;
        private KeyStore m_trustStore = null;

        public InternalEasyX509TrustManager(KeyStore trustStore) throws NoSuchAlgorithmException, KeyStoreException {
            WSJSSE wsjsse = WSJSSE.getInstance();
            TrustManagerFactory factory = TrustManagerFactory.getInstance(wsjsse.getKeyManagerAlgorithm());
            factory.init(trustStore);
            this.m_trustStore = trustStore;
            TrustManager[] trustmanagers = factory.getTrustManagers();
            if (trustmanagers.length == 0) {
                throw new NoSuchAlgorithmException("SunX509 trust manager not supported");
            }
            this.standardTrustManager = (X509TrustManager)trustmanagers[0];
        }

        public void checkClientTrusted(X509Certificate[] certificates, String authType) throws CertificateException {
            this.standardTrustManager.checkClientTrusted(certificates, authType);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void checkServerTrusted(X509Certificate[] certificates, String authType) throws CertificateException {
            String m_method = "isServerTrusted:" + WSValidateServerCertificate.getCertificateAlias(certificates[0]);
            if (logger.isFinest()) {
                logger.finest(m_className, m_method, "ENTER");
            }
            boolean bTrusted = false;
            try {
                try {
                    this.standardTrustManager.checkServerTrusted(certificates, authType);
                    bTrusted = true;
                }
                catch (CertificateException ex) {
                    if (certificates != null && WSValidateServerCertificate.this.m_bAutoTrusted) {
                        bTrusted = WSValidateServerCertificate.this.handleUntrustedCertificates(this.m_trustStore, certificates);
                    }
                    if (!bTrusted) {
                        throw ex;
                    }
                    Object var7_6 = null;
                    if (logger.isFinest()) {
                        logger.finest(m_className, m_method, "EXIT:" + new Boolean(bTrusted).toString());
                    }
                }
                Object var7_5 = null;
                if (logger.isFinest()) {
                    logger.finest(m_className, m_method, "EXIT:" + new Boolean(bTrusted).toString());
                }
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (logger.isFinest()) {
                    logger.finest(m_className, m_method, "EXIT:" + new Boolean(bTrusted).toString());
                }
                throw throwable;
            }
        }

        public X509Certificate[] getAcceptedIssuers() {
            return this.standardTrustManager.getAcceptedIssuers();
        }
    }

    class InternalEasySSLSocketFactory
    extends SSLSocketFactory {
        private SSLSocketFactory getEasySSLSocketFactory() {
            String m_method = "getEasySSLSocketFactory";
            KeyStore truststore = null;
            SSLContext context = null;
            try {
                String trustStorePath = null;
                char[] pword = null;
                if (s_bProcessTrustStoreSaved && s_processTrustStorePath != null) {
                    trustStorePath = s_processTrustStorePath;
                    pword = s_processTrustStorePassword;
                } else if (s_defaultTrustStorePath != null) {
                    trustStorePath = s_defaultTrustStorePath;
                    String password = System.getProperty(WSValidateServerCertificate.TRUSTSTORE_PASSWORD_PROPERTY);
                    if (password != null) {
                        pword = password.toCharArray();
                    }
                }
                if (logger.isFinest()) {
                    logger.finest(m_className, "getEasySSLSocketFactory", "trustStorePath=" + trustStorePath);
                }
                if (trustStorePath != null) {
                    WSJSSE wsjsse = WSJSSE.getInstance();
                    KeyManagerFactory factory = KeyManagerFactory.getInstance(wsjsse.getKeyManagerAlgorithm());
                    truststore = KeyStore.getInstance(wsjsse.getKeyStoreType());
                    truststore.load(new FileInputStream(new File(trustStorePath)), pword);
                    factory.init(truststore, pword);
                }
                context = SSLContext.getInstance("SSL");
                TrustManager[] trustManagers = new TrustManager[]{new InternalEasyX509TrustManager(truststore)};
                context.init(null, trustManagers, null);
            }
            catch (Exception e) {
                throw new RuntimeException(e.toString());
            }
            return context.getSocketFactory();
        }

        public Socket createSocket(String host, int port, InetAddress clientHost, int clientPort) throws IOException, UnknownHostException {
            Socket socket = this.getEasySSLSocketFactory().createSocket(host, port, clientHost, clientPort);
            return socket;
        }

        public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
            return this.getEasySSLSocketFactory().createSocket(host, port);
        }

        public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException, UnknownHostException {
            return this.getEasySSLSocketFactory().createSocket(socket, host, port, autoClose);
        }

        public String[] getDefaultCipherSuites() {
            return this.getEasySSLSocketFactory().getSupportedCipherSuites();
        }

        public String[] getSupportedCipherSuites() {
            return this.getEasySSLSocketFactory().getSupportedCipherSuites();
        }

        public Socket createSocket(InetAddress host, int port) throws IOException {
            return this.getEasySSLSocketFactory().createSocket(host, port);
        }

        public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
            return this.getEasySSLSocketFactory().createSocket(address, port, localAddress, localPort);
        }
    }
}

